/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.CoDataLoad;
import com.quantumdata.ftp.CoFile;
import com.quantumdata.ftp.CoProgress;
import com.quantumdata.ftp.CoProgressNull;
import com.quantumdata.std.IQDConsole;
import java.io.IOException;

public abstract class CoLoad {
    IQDConsole console;

    CoLoad() {
    }

    public static boolean delete(CoFile[] coFileArray) {
        return CoLoad.delete(coFileArray, new CoProgressNull());
    }

    public static boolean delete(CoFile[] coFileArray, CoProgress coProgress) {
        boolean bl = true;
        if (coFileArray != null) {
            for (int i = 0; i < coFileArray.length; ++i) {
                if (!coFileArray[i].isDirectory()) {
                    if (coProgress.isAborted()) {
                        bl = false;
                        break;
                    }
                    coProgress.setFile(coFileArray[i]);
                    if (coFileArray[i].delete()) continue;
                    bl = false;
                    break;
                }
                if (!coFileArray[i].isDirectory()) continue;
                try {
                    if (coProgress.isAborted()) {
                        bl = false;
                        break;
                    }
                    if (!CoLoad.delete(coFileArray[i].listCoFiles(), coProgress)) {
                        bl = false;
                        break;
                    }
                    coProgress.setFile(coFileArray[i]);
                    if (coFileArray[i].delete()) continue;
                    bl = false;
                }
                catch (SecurityException securityException) {
                    bl = false;
                }
                break;
            }
        }
        return bl;
    }

    public static boolean copy(CoFile coFile, CoFile[] coFileArray) {
        return CoLoad.copy(coFile, coFileArray, (CoProgress)new CoProgressNull());
    }

    public static boolean copy(CoFile coFile, CoFile[] coFileArray, CoProgress coProgress) {
        boolean bl = true;
        if (coFileArray != null) {
            for (int i = 0; i < coFileArray.length; ++i) {
                CoFile coFile2;
                if (coFileArray[i].isFile()) {
                    if (coProgress.isAborted()) {
                        bl = false;
                        break;
                    }
                    coFile2 = coFile.newFileChild(coFileArray[i].getName());
                    coProgress.setFile(coFile2, coFileArray[i]);
                    if (CoLoad.copy(coFile2, coFileArray[i], coProgress)) continue;
                    bl = false;
                    break;
                }
                if (!coFileArray[i].isDirectory()) continue;
                try {
                    if (coProgress.isAborted()) {
                        bl = false;
                        break;
                    }
                    coFile2 = coFile.newFileChild(coFileArray[i].getName());
                    coProgress.setFile(coFile2, coFileArray[i]);
                    coFile2.mkdir();
                    CoFile[] coFileArray2 = coFileArray[i].listCoFiles();
                    if (coFileArray2 == null) {
                        return false;
                    }
                    if (CoLoad.copy(coFile.newFileChild(coFileArray[i].getName()), coFileArray2, coProgress)) continue;
                    bl = false;
                }
                catch (SecurityException securityException) {
                    bl = false;
                }
                break;
            }
        }
        return bl;
    }

    public static boolean copy(CoFile coFile, CoFile coFile2) {
        return CoLoad.copy(coFile, coFile2, (CoProgress)new CoProgressNull());
    }

    public static boolean copy(CoFile coFile, CoFile coFile2, CoProgress coProgress) {
        IQDConsole iQDConsole = null;
        if (coFile.getConsole() != null) {
            iQDConsole = coFile.getConsole();
        } else if (coFile2.getConsole() != null) {
            iQDConsole = coFile2.getConsole();
        } else if (iQDConsole == null) {
            iQDConsole = new IQDConsole(){

                public void println(String string) {
                }
            };
        }
        return CoLoad.copy(coFile, coFile2, coProgress, iQDConsole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(CoFile coFile, CoFile coFile2, CoProgress coProgress, IQDConsole iQDConsole) {
        boolean bl = false;
        CoLoad coLoad = null;
        try {
            coLoad = CoLoad.open(coFile, coFile2, iQDConsole);
            int n = 0;
            while (n != -1) {
                if (coProgress.isAborted()) {
                    bl = false;
                    break;
                }
                try {
                    n = coLoad.transfer();
                }
                catch (IOException iOException) {
                    coProgress.setDelay(60000L);
                    n = 0;
                }
                if (n == -1) continue;
                coProgress.setProgress(n);
            }
            bl = true;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (coLoad != null) {
                    coLoad.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    static CoLoad open(CoFile coFile, CoFile coFile2, IQDConsole iQDConsole) throws IOException {
        return new CoDataLoad(coFile, coFile2, iQDConsole);
    }

    abstract int transfer() throws IOException;

    abstract void close() throws IOException;
}

